define( [
        'jquery'
    ],
    function ( $ ) {
        'use strict';

        return {
			//Define what our properties panel look like
			definition: {
				type: "items",
				component: "accordion",
				items: {
					appearancePanel: {
						uses: "settings",
						items: {
							MyStringProp: {
								ref: "myDynamicOutput",
								type: "string",
								label: "Hello World Text",
								defaultValue: "Hello world"
							}
						}
					}
				}
			},

            //Paint resp.Rendering logic
            paint: function ( $element, layout ) {

				$element.empty();
				var $helloWorld = $( document.createElement( 'div' ) );
                $helloWorld.html( layout.myDynamicOutput );
                $element.append( $helloWorld );

            }
        };
    } );